"""
Constants for all modules of HDL-FSM-Editor
"""

# from enum import StrEnum # StrEnum does not exist in Linux Mint
from enum import Enum

VERSION = "6.1"
HEADER_STRING = (
    "HDL-FSM-Editor\nVersion " + VERSION + "\nCreated by Matthias Schweikart\nContact: matthias.schweikart@gmx.de"
)

VHDL_HIGHLIGHT_PATTERN_DICT = {
    "not_read": ["dummy_entry_so_that_this_list_is_no_empty"],
    "not_written": ["dummy_entry_so_that_this_list_is_no_empty"],
    "control": [
        "library",
        "use",
        "all",
        "entity",
        "is",
        "port",
        "generic",
        "end",
        "if",
        "then",
        "else",
        "elsif",
        "downto",
        "to",
        "architecture",
        "of",
        "type",
        "signal",
        "variable",
        "constant",
        "begin",
        "process",
        "case",
        "others",
        "while",
        "select",
        "with",
        "when",
        "=>",
        "in",
        "out",
        "inout",
        "buffer",
        "for",
        "loop",
        "assert",
        "report",
        "lf",
        "severity",
    ],
    "datatype": [
        "std_logic",
        "std_logic_vector",
        "integer",
        "boolean",
        "bit",
        "bit_vector",
        "real",
        "natural",
        "positive",
        "signed",
        "unsigned",
        "ieee",
        "std_logic_1164",
        "numeric_std",
    ],
    # From std_logic_1164, numeric_std:
    "function": [
        "rising_edge",
        "falling_edge",
        "and",
        "nand",
        "or",
        "nor",
        "xnor",
        "xor",
        "not",
        "to_stdulogic",
        "to_stdlogicvector",
        "to_stdulogicvector",
        "abs",
        "rem",
        "mod",
        "shift_left",
        "shift_right",
        "rotate_left",
        "rotate_right",
        "resize",
        "to_integer",
        "to_unsigned",
        "to_signed",
        "std_match",
    ],
    # It is important to have "comment" at the end, as all other highlighting-tags are removed in the comment area.
    "comment": [r"--.*?$", r"/\*.*?\*/"],
}
VHDL_KEYWORDS_FOR_SIGNAL_HANDLING = (
    " to_stdulogic ",
    " to_stdlogicvector ",
    " to_stdulogicvector ",
    " to_integer ",
    " to_unsigned ",
    " to_signed ",
    " shift_left ",
    " shift_right ",
    " rotate_left ",
    " rotate_right ",
    " resize ",
    " abs ",
    " after ",
    " and ",
    " assert .*?;",  # muessen komplett geloescht werden!
    " downto ",
    " exit ",
    " for ",
    " in ",
    " mod ",
    " nand ",
    " next ",
    " nor ",
    " not ",
    " null ",
    " loop ",
    " or ",
    " others ",
    " rem ",
    " report .*?;",  # muessen komplett geloescht werden!
    " return ",
    " rol ",
    " ror ",
    " sla ",
    " sll ",
    " sra ",
    " srl ",
    " to ",
    " transport ",
    " wait .*?;",  # muessen komplett geloescht werden!
    " while ",
    " xnor ",
    " xor ",
)
_VHDL_KEYWORDS_ALL_UNUSED = (
    " access ",
    " assert ",
    " alias ",
    " all ",
    " architecture ",
    " array ",
    " attribute ",
    " begin ",
    " block ",
    " body ",
    " buffer ",
    " bus ",
    " case ",
    " component ",
    " configuration ",
    " constant ",
    " disconnect ",
    " elsif ",
    " end ",
    " entity ",
    " file ",
    " function ",
    " generate ",
    " generic ",
    " group ",
    " guarded ",
    " if ",
    " impure ",
    " inertial ",
    " inout ",
    " is ",
    " label ",
    " library ",
    " linkage ",
    " literal ",
    " map ",
    " new ",
    " of ",
    " on ",
    " open ",
    " out ",
    " package ",
    " port ",
    " postponed ",
    " procedure ",
    " pure ",
    " record ",
    " register ",
    " reject ",
    " report ",
    " severity ",
    " signal ",
    " shared ",
    " subtype ",
    " then ",
    " type ",
    " unaffected ",
    " units ",
    " until ",
    " use ",
    " variable ",
    " wait ",
)

VERILOG_HIGHLIGHT_PATTERN_DICT = {
    "not_read": ["dummy_entry_so_that_this_list_is_no_empty"],
    "not_written": ["dummy_entry_so_that_this_list_is_no_empty"],
    "control": [
        "module",
        "endmodule",
        "parameter",
        "input",
        "output",
        "inout",
        "always",
        "posedge",
        "negedge",
        "begin",
        "end",
        "if",
        "else",
        "case",
        "endcase",
        "assign",
        "while",
        "for",
        "initial",
        "localparam",
        "default",
        "typedef",
        "enum",
    ],
    "datatype": ["wire", "reg", "integer", "boolean", "bit", "bit_vector", "real", "logic"],
    "function": ["and", "nand", "or", "nor", "xnor", "xor", "not"],
    # It is important to have "comment" at the end of this list, as all other highlighting-tags are
    # removed when highlighting works at the comment keyword.
    "comment": [r"//.*?$", r"/\*.*?\*/"],
}
VERILOG_KEYWORDS_FOR_SIGNAL_HANDLING = (" or ", " and ", " assign ", " nand ", " nor ", " not ", " xnor ", " xor ")
_VERILOG_KEYWORDS_ALL_UNUSED = (
    " always ",
    " end ",
    " ifnone ",
    " rpmos ",
    " tranif1 ",
    " endcase ",
    " initial ",
    " output ",
    " rtran ",
    " tri ",
    " endmodule ",
    " inout ",
    " parameter ",
    " rtranif0 ",
    " tri0 ",
    " begin ",
    " endfunction ",
    " input ",
    " pmos ",
    " rtranif1 ",
    " tri1 ",
    " buf ",
    " endprimitive ",
    " integer ",
    " posedge ",
    " scalared ",
    " triand ",
    " bufif0 ",
    " endspecify ",
    " join ",
    " primitive ",
    " small ",
    " trior ",
    " bufif1 ",
    " endtable ",
    " large ",
    " pull0 ",
    " specify ",
    " trireg ",
    " case ",
    " endtask ",
    " macromodule ",
    " pull1 ",
    " specparam ",
    " vectored ",
    " casex ",
    " event ",
    " medium ",
    " pullup ",
    " strong0 ",
    " wait ",
    " casez ",
    " for ",
    " module ",
    " pulldown ",
    " strong1 ",
    " wand ",
    " cmos ",
    " force ",
    " rcmos ",
    " supply0 ",
    " weak0 ",
    " deassign ",
    " forever ",
    " negedge ",
    " real ",
    " supply1 ",
    " weak1 ",
    " default ",
    " for ",
    " nmos ",
    " realtime ",
    " table ",
    " while ",
    " defparam ",
    " function ",
    " reg ",
    " task ",
    " wire ",
    " disable ",
    " highz0 ",
    " release ",
    " time ",
    " wor ",
    " edge ",
    " highz1 ",
    " notif0 ",
    " repeat ",
    " tran ",
    " else ",
    " if ",
    " notif1 ",
    " rnmos ",
    " tranif0 ",
)


CONNECTOR_COLOR = "violet"
STATE_COLOR = "cyan"


# class GuiTab(StrEnum): # StrEnum does not exist in Linux Mint
class GuiTab(str, Enum):
    """Used to identify the tab in the application"""

    CONTROL = "Control"
    INTERFACE = "Interface"
    INTERNALS = "Internals"
    DIAGRAM = "Diagram"
    GENERATED_HDL = "Generated HDL"
    COMPILE_MSG = "Compile Messages"
